﻿using System.IO;
using System.Reflection;
using System.Xml.Serialization;

namespace Azyobuzi.Twikoto2.Models
{
    public class Settings : MyNotifyObject
    {
        /*
         * NotifyObjectはプロパティ変更通知の仕組みを実装したオブジェクトです。
         */

        /*
         * リッチクライアントはステートフルであるため、通常のイベントの使用はメモリリークの原因になりやすくなっています。
         * Modelからイベントを発行する場合はNotificatorを使用してください。
         *
         * Notificatorはイベント代替手段です。コードスニペット lnev でCLRイベントと同時に定義できます。
         *
         * Model同士でNotificatorを使用した通知を行う場合はNotificatorHelper、
         * ViewModelへNotificatorを使用した通知を行う場合はViewModelHelperを使用して受信側の登録をしてください。
         */

        private Settings() { }

        private static string GetSettingsFile()
        {
            return Path.GetDirectoryName(Assembly.GetCallingAssembly().Location)
                + @"\settings.xml";
        }

        private static Settings instance;
        public static Settings Instance
        {
            get
            {
                if (instance == null)
                {
                    try
                    {
                        using (var sr = new StreamReader(GetSettingsFile()))
                        {
                            instance = (Settings)new XmlSerializer(typeof(Settings)).Deserialize(sr);
                        }
                    }
                    catch
                    {
                        instance = new Settings();
                    }
                }

                return instance;
            }
        }

        public void Save()
        {
            using (var sw = new StreamWriter(GetSettingsFile()))
            {
                new XmlSerializer(typeof(Settings)).Serialize(sw, this);
            }
        }

        #region 設定項目
        string _AccessToken;
        public string AccessToken
        {
            get
            { return _AccessToken; }
            set
            {
                if (_AccessToken == value)
                    return;
                _AccessToken = value;
                RaisePropertyChanged("AccessToken");
            }
        }

        string _AccessTokenSecret;
        public string AccessTokenSecret
        {
            get
            { return _AccessTokenSecret; }
            set
            {
                if (_AccessTokenSecret == value)
                    return;
                _AccessTokenSecret = value;
                RaisePropertyChanged("AccessTokenSecret");
            }
        }

        string _ScreenName;
        public string ScreenName
        {
            get
            { return _ScreenName; }
            set
            {
                if (_ScreenName == value)
                    return;
                _ScreenName = value;
                RaisePropertyChanged("ScreenName");
            }
        }

        double _WindowWidth = 525d;
        public double WindowWidth
        {
            get
            { return _WindowWidth; }
            set
            {
                if (_WindowWidth == value)
                    return;
                _WindowWidth = value;
                RaisePropertyChanged("WindowWidth");
            }
        }

        double _WindowHeight = 350d;
        public double WindowHeight
        {
            get
            { return _WindowHeight; }
            set
            {
                if (_WindowHeight == value)
                    return;
                _WindowHeight = value;
                RaisePropertyChanged("WindowHeight");
            }
        }

        double _WindowLeft = double.NaN;
        public double WindowLeft
        {
            get
            { return _WindowLeft; }
            set
            {
                if (_WindowLeft == value)
                    return;
                _WindowLeft = value;
                RaisePropertyChanged("WindowLeft");
            }
        }

        double _WindowTop = double.NaN;
        public double WindowTop
        {
            get
            { return _WindowTop; }
            set
            {
                if (_WindowTop == value)
                    return;
                _WindowTop = value;
                RaisePropertyChanged("WindowTop");
            }
        }

        #endregion
    }
}
